#include <bits/stdc++.h>

using namespace std;

const int max_n = 1e5 + 5;
const int max_d = 19;

int p[max_n] = {0};
int sz[max_n] = {0};
vector<int> numbers;
vector<int> order;
vector<int> u, v;
int n, m;


int get_p(int node){
    if (p[node] == node) return node;
    p[node] = get_p(p[node]);
    return p[node];
}


void join(int node1, int node2){
    int p1 = get_p(node1);
    int p2 = get_p(node2);
    if (sz[p1] > sz[p2]){
        sz[p1] += sz[p2];
        p[p2] = p1;
    }
    else{
        sz[p2] += sz[p1];
        p[p1] = p2;
    }
}


void dfs(int pos){
    if (pos == m){
        if (order.size() == n - 1){
            for (int eid : order){
                p[u[eid]] = u[eid];
                p[v[eid]] = v[eid];
                sz[u[eid]] = 0;
                sz[v[eid]] = 0;
            }
            int joined = 0;
            for (int ei : order){
                if (get_p(u[ei]) != get_p(v[ei])){
                    joined++;
                    join(u[ei], v[ei]);
                }
            }
            if (joined == n - 1){
                int num = 0;
                for (int elm : order) num |= (1 << elm);
                numbers.push_back(num);
            }
        }
    }
    else{
        order.push_back(pos);
        dfs(pos + 1);
        order.pop_back();
        dfs(pos + 1);
    }
}


int Sabiranje(int N, int M, long long K, int* U, int* V){
    n = N;
    m = M;
    for (int i = 1; i <= M; i++){
        u.push_back(U[i]);
        v.push_back(V[i]);
    }
    dfs(0);
    vector<int> basis(max_d, 0);
    for (int num : numbers){
        for (int i = max_d - 1; i >= 0; i--) if (num & (1 << i)){
            if (basis[i] == 0){
                basis[i] = num;
                break;
            }
            else num ^= basis[i];
        }
    }
    int ans = 0;
    for (int i = max_d - 1; i >= 0; i--) if (basis[i] != 0) ans++;
    return (1 << ans);
}
/*
4 5 2
1 2
2 4
4 3
3 1
1 4

5 5 2
1 2
2 3
3 4
4 2
5 4
*/